package jamezo97.clonecraft.block;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.network.Handler3LifeInducerUpdates;

import java.util.List;

import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityLifeInducer extends TileEntity implements IInventory{
	
	ItemStack[] items = new ItemStack[27];
	
	//Max = 160
	public int storedPower = 0;
	
	
	public TileEntityLifeInducer() {
		super();
	}
	
	
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		storedPower = nbt.getInteger("storedPower");
		NBTTagList list = nbt.getTagList("Items");
		for(int a = 0; a < list.tagCount(); a++){
			NBTTagCompound itemNbt = (NBTTagCompound)list.tagAt(a);
			int index = itemNbt.getInteger("ItemSlotIndex");
			items[index] = ItemStack.loadItemStackFromNBT(itemNbt);
		}
		untilStrike = nbt.getInteger("untilStrike");
		fails = nbt.getInteger("fails");
	}

	boolean spawn = false;
	
	public void setToSpawn(){
//		System.out.println("Set to spawn");
		spawn = true;
		
	}



	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		nbt.setInteger("storedPower", storedPower);
		NBTTagList list = new NBTTagList();
		for(int a = 0; a < items.length; a++){
			if(items[a] != null){
				NBTTagCompound itemNbt = new NBTTagCompound();
				items[a].writeToNBT(itemNbt);
				itemNbt.setInteger("ItemSlotIndex", a);
				list.appendTag(itemNbt);
			}
		}
		nbt.setTag("Items", list);
		nbt.setInteger("untilStrike", untilStrike);
		nbt.setInteger("fails", fails);
	}
	int maxReduction = 1;//200;

	int maxUntilStrike = 40;//400;

	int untilStrike = maxUntilStrike - maxReduction;

	int maxFails = 0;
	
	int fails = 0;
	
	@Override
	public void updateEntity() {
		if(!worldObj.isRemote){
			if(storedPower > 0){
				for(int a = 0; a < items.length; a++){
					if(storedPower > 0){
						if(items[a] != null){
							if(items[a].itemID == CloneCraft.spawnEgg.itemID && items[a].getItemDamage() == 0){
								items[a].setItemDamage(1);
								storedPower--;
							}
						}
					}else{
						break;
					}
				}
			}
/*			if(worldObj.isRaining()){
				untilStrike--;
				if(untilStrike % 100 == 0){
					System.out.println("Going down: " + untilStrike);
				}
				if(untilStrike <= 0){
					if(fails == maxFails || worldObj.rand.nextInt(4) == 0){
						fails = 0;
						int topPoint = strike();
						if(topPoint > -1){
							if(topPoint == yCoord){
								CloneCraft.antenna.chargeLifeMachine(xCoord, yCoord, zCoord, worldObj, this);
							}else{
								CloneCraft.antenna.chargeAntenna(xCoord, topPoint, zCoord, worldObj);
							}
						}
					}else{
						fails++;
					}
					untilStrike = maxUntilStrike - (worldObj.rand.nextInt(maxReduction));
				}
			}*/
		}
	}
	
	public void charge(){
		storedPower += 16;
		if(storedPower > 160){
			storedPower = 160;
		}
	}
	
	
/*	public int getTopAntennaBlock(){
		int y = yCoord;
		int max = 255;
		while(max-- > 0){
			int above = y + 1;
			if(above >= 255){
				break;
			}else{
				int id = worldObj.getBlockId(xCoord, above, zCoord);
				if(id == CloneCraft.antenna.blockID){
					y = above;
					continue;
				}else{
					break;
				}
			}
		}
		return y;
	}*/

	public int getTopConductiveBlock(int x, int z){
		int y = 256;
		while(y > 0){
			y--;
			int id = worldObj.getBlockId(x, y, z);
			if(id == CloneCraft.antenna.blockID || id == CloneCraft.lifeInducer.blockID){
				return y;
			}
		}
		return -1;
	}
	
	
	public int strike(){
		int x = xCoord;
		int z = zCoord;
		int topConductive = getTopConductiveBlock(xCoord, zCoord);
		int topSolid = worldObj.getTopSolidOrLiquidBlock(xCoord, zCoord)-1;
		if(topConductive >= topSolid){
			int minX = x - 20;
			int minZ = z - 20;
			int maxX = x + 20;
			int maxZ = z + 20;
			for(int zC = minZ; zC <  maxZ; zC++){
				for(int xC = minX; xC <  maxX; xC++){
					if(zC != z && xC != x){
						int highest = worldObj.getTopSolidOrLiquidBlock(xC, zC);
						if(highest >= topConductive){
//							System.out.println("C" + topConductive + "|" + highest);
							return -1;
						}
					}
				}
			}
			EntityLightningBolt bolt = new EntityLightningBolt(worldObj, x, topConductive+1, z);
			worldObj.addWeatherEffect(bolt);
			return topConductive;
		}
		return -1;
	}




	@Override
	public int getSizeInventory() {
		return 27;
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return items[i];
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		if (items[i] != null) {
			if (items[i].stackSize <= j) {
				ItemStack itemstack = items[i];
				items[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = items[i].splitStack(j);
			if (items[i].stackSize == 0) {
				items[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int i) {
		if(items[i] != null){
			ItemStack stack = items[i];
			items[i] = null;
			return stack;
		}
		return null;
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		items[i] = itemstack;
		if(items[i] != null && items[i].stackSize > getInventoryStackLimit()){
			items[i].stackSize = getInventoryStackLimit();
		}
	}

	@Override
	public String getInvName() {
		return "Life Transmogrifier";
	}

	@Override
	public boolean isInvNameLocalized() {
		return true;
	}

	@Override
	public int getInventoryStackLimit() {
		return 1;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		}
		return entityplayer.getDistanceSq((double) xCoord + 0.5D, (double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
	}

	@Override
	public void openChest() {
	}

	@Override
	public void closeChest() {
	}

	@Override
	public boolean isItemValidForSlot(int i, ItemStack itemstack) {
		return false;
	}



	public boolean isValidItem(ItemStack stack) {
		if(stack == null || (stack.itemID == CloneCraft.spawnEgg.itemID && stack.getItemDamage() == 0)){
			return true;
		}
		return false;
	}


	
	public void onBroken() {
		if(storedPower > 0){
			explode(worldObj, xCoord, yCoord, zCoord, storedPower);
		}
		
	}



	public static void explode(World world, int x, int y, int z, int power) {
		List entities = world.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox(x, y, z, x+1, y+1, z+1).expand(64, 48, 64));
		double xMid = x+.5;
		double yMid = y-.5;
		double zMid = z+.5;

		double storedEnergy = ((double)power) / 14d;

		for(int a = 0; a < entities.size(); a++){
			Entity e = (Entity)entities.get(a);
			if(e != null){

				double xE = e.posX;
				double yE = e.posY;
				double zE = e.posZ;

				double dX = xE - xMid;
				double dY = yE - yMid;
				double dZ = zE - zMid;

				double distance = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
				float attack = 4.0f*((float)storedEnergy)/4f / (float)distance;
				e.attackEntityFrom(DamageSource.generic, attack);
				e.velocityChanged = false;

				dX /= distance;
				dY /= distance;
				dZ /= distance;



				e.motionX += dX*storedEnergy;
				e.motionY += dY*storedEnergy;
				e.motionZ += dZ*storedEnergy;
				e.velocityChanged = true;
			}
		}
	}

	
	

}
